/*
 *  LICENSE:
 *  Copyright (c) 2008 Freescale Semiconductor
 *  
 *  Permission is hereby granted, free of charge, to any person 
 *  obtaining a copy of this software and associated documentation 
 *  files (the "Software"), to deal in the Software without 
 *  restriction, including without limitation the rights to use, 
 *  copy, modify, merge, publish, distribute, sublicense, and/or 
 *  sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following 
 *  conditions:
 *  
 *  The above copyright notice and this permission notice 
 *  shall be included in all copies or substantial portions 
 *  of the Software.
 *  
 *  THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 *  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES 
 *  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 *  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT 
 *  HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
 *  WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 *  
 *
 *  File: $Id: axedatatype-conv.h,v 1.4 2008/08/01 20:57:20 b17778 Exp $
 *
 */




///////////////////////////////////////////////////////////////////////////////////////////////
// The Axe datatype concersion library can be used on both sides: AXE and PPC. Because there //
// is no shared float, fixed, double, accum datatypes new datatypes has to by defined based  //
// on common types like unsigned integer.                                                    //
//                                                                                           //
//                                                                                           //
//                                                                                           //
//             6         5         4         3         2         1         0                 //
//          3210987654321098765432109876543210987654321098765432109876543210                 //
//  double: SEEEEEEEEEEEMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM                 //
// __accum: UUUUUUUUSIIIIIIIMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMUUUUUUUUUUUUUUUUU                 //
// __fixed:                                 SMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM                 //
//                                                                                           //
// S = sign bit;  E = Exponent; M = matisse; U = unused                                      //
// Constants (from double to __accum):                                                       //
//                                                                                           //
// DOUBLE_SIZE = 64                                                                          //
// DOUBLE_SIGN_POS = 63                                                                      //
// DOUBLE_EXP_POS = 62                                                                       //
// DOUBLE_EXP_SIZE = 11                                                                      //
// DOUBLE_MATISSE_POS = 51                                                                   //
// DOUBLE_MATISSE_SIZE = 52                                                                  //
// DOUBLE_BIAS = 1023                                                                        //
// DOUBLE_HIDDEN_BIT = 1                                                                     //
// ACCUM_SIZE = 64                                                                           //
// ACCUM_SIGN_POS = 55                                                                       //
// ACCUM_INTEGER_POS = 54                                                                    //
// ACCUM_INTEGER_SIZE = 7                                                                    //
// ACCUM_MATISSE_POS = 47                                                                    //
// ACCUM_MATISSE_SIZE = 31                                                                   //
// ACCUM_FIRST_UNUSED_POS = 63                                                               //
// ACCUM_FIRST_UNUSED_SIZE = 8                                                               //
// ACCUM_SECOND_UNUSED_POS = 16                                                              //
// ACCUM_SECOND_UNUSED_SIZE = 17                                                             //
// FIXED_SIZE = 32                                                                           //
// FIXED_SIGN_POS = 31                                                                       //
// FIXED_MATISSE_POS = 30                                                                    //
// FIXED_MATISSE_SIZE = 31                                                                   //
//                                                                                           //
//                                                                                           //
//                                                                                           //
//                                                                                           //
// SIGN_OFFSET = 8 : the value the signbit have to be shifted                                //
// MATISSE_OFFSET = 4 : the value the matisse has to be shifted                              //
// EXPONENT_SHIFT = 52 : the value the exponent has to be right shifted to obtain an integer //
// HALF_ACCUM_LENGTH = 32 : the half length of the __accum type in bit                       //
// BIAS = 1023 : exponent - BIAS = exponent in signed integer                                //
// POS_OF_1_BIT_IN_ACCUM = 48 : the position of the first integer bit in __accum             //
//                                                                                           //
///////////////////////////////////////////////////////////////////////////////////////////////


#define DOUBLE_SIZE 64
#define DOUBLE_SIGN_POS 63
#define DOUBLE_EXP_POS 62
#define DOUBLE_EXP_SIZE 11
#define DOUBLE_MATISSE_POS 51
#define DOUBLE_MATISSE_SIZE 52
#define DOUBLE_BIAS 1023
#define DOUBLE_HIDDEN_BIT 1
#define ACCUM_SIZE 64
#define ACCUM_SIGN_POS 55  
#define ACCUM_INTEGER_POS 54
#define ACCUM_INTEGER_SIZE 7
#define ACCUM_MATISSE_POS 47
#define ACCUM_MATISSE_SIZE 31
#define ACCUM_FIRST_UNUSED_POS 63
#define ACCUM_FIRST_UNUSED_SIZE 8
#define ACCUM_SECOND_UNUSED_POS 16
#define ACCUM_SECOND_UNUSED_SIZE 17
#define FIXED_SIZE 32
#define FIXED_SIGN_POS 31  
#define FIXED_MATISSE_POS 30
#define FIXED_MATISSE_SIZE 31


#define DOUBLE_MATISSE_MASK_FIRST 0x000FFFFF
#define DOUBLE_MATISSE_MASK_SECOND 0xFFFFFFFF
#define DOUBLE_HIDDEN_BIT_MASK 0xFFEFFFFF
#define DOUBLE_EXP_MASK 0x7FF00000

#define ACCUM_SIGN_BIT_MASK 0xFF7FFFFF
#define ACCUM_UNUSED_MASK_FIRST 0x00FFFFFF
#define ACCUM_UNUSED_MASK_SECOND 0xFFFE0000


#define SIGN_OFFSET  8
#define MATISSE_OFFSET  4
#define EXPONENT_SHIFT  52
#define HALF_ACCUM_LENGTH  32
#define BIAS  1023
#define POS_OF_1_BIT_IN_ACCUM  48

#define ERR_OK 0
#define ERR_RANGE -1

/*
 * defines the __accum type
 */
#ifndef __accum
typedef struct 
{
	unsigned int first;   // first 32 bits
	unsigned int second;  // second 32 bits
} __accum;
#endif

/*
 * defines the __fixed type
 */
#ifndef __fixedaasasa
#define __fixed unsigned int
#endif

/*
 * defines the __accum type
 */
#ifndef __double
typedef struct
{
	unsigned int first;   // first 32 bits
	unsigned int second;  // second 32 bits
} __double;
#endif


/*
 * the longType abstracts __double and __accum
 * it is used for template function for both datatypes
 */
#ifndef __longType
typedef struct
{
	unsigned int first;   // first 32 bits
	unsigned int second;  // second 32 bits
} __longType;
#endif


/*
 * defines the __float type
 */
#ifndef __float
#define __float unsigned int
#endif

/**
 *	\brief	 implements "<<" for longTypes
 *	\param[in] longType to be shifted  
 *	\param[in] value of how many positions to shift 
 *	\return    void
 *
 *  \note
 *  
 *  This method can be used to shift __double and __accum types
 *  A shift of a negative number equals a shift of the absolue 
 *  value to the right.
 */
void __longTypeLeftShift(__longType *pl, int shift);
//****************************************************************

/**
 *	\brief	 implements ">>" for longTypes
 *	\param[in] longType to be shifted  
 *	\param[in] value of how many positions to shift 
 *	\return    void
 *
 *  \note
 *  
 *  This method can be used to shift __double and __accum types
 *  A shift of a negative number equals a shift of the absolue 
 *  value to the left.
 */
void __longTypeRightShift(__longType *pl, int shift);
//****************************************************************

/*****************************************************************
 *	\brief	 implements "+" for longTypes (a+b=c)
 *	\param[in] addend 1 (a) 
 *	\param[in] addend 2 (b)
 *  \param[out] result (c)
 *	\return    void
 *
 *  \note
 *  
 *  This method can be used to add __double and __accum types
 *  
 */
void __longTypeAdd(__longType *pa, __longType *pb, __longType *pc);
//****************************************************************

/*****************************************************************
 *	\brief	 implements "a++" for longTypes (a = a+1)
 *	\param[in] longType to be incremented
 *	\return    void
 *
 *  \note
 *  
 *  This method can be used to increment __accum and __double 
 *  types by one
 *  
 */
void __longTypeInc(__longType *pa);
//****************************************************************

/*****************************************************************
 *	\brief	 returns position of first 1 bit in a longType
 *	\param[in] longType where to be searched
 *	\return    position of first 1 bit
 *
 *  \note
 *  
 *  This method is useful to define the exponent of a double when
 *  converting from a fixed or accum.
 *  If longType = 0x0001555555555555 it would return 58.
 *  The complexity of the algorithm is in average O(ld(64))
 *  
 */
int __findFirstOccurenceOf1inLongType(__longType *pl);
//****************************************************************

/*****************************************************************
 *	\brief	 converts double==__double type to __accum
 *	\param[in] source 
 *	\param[out] destination 
 *  \return -1 if double is out of accum range, 0 else
 *
 *  \note
 *  
 *  This method is just without data loss for 
 *  0 <= exponent(double) < 128
 *  if exponent >= 127 it returns a failure
 *  if exponent < 0 the matisse is cutted by |exponent| bits
 *  
 */
int __doubleToAccum(__double *pd, __accum *pa);
//****************************************************************

/*****************************************************************
 *	\brief	 converts __accum type to __double == double
 *	\param[in] source 
 *	\param[out] destination 
 *  \return   void
 *
 *  \note
 *  
 *  This method suffers never data loss
 *  
 */
void __accumToDouble(__accum *pa, __double *pd);
//****************************************************************

/*****************************************************************
 *	\brief	 converts double ==__double type to __fixed
 *	\param[in] source 
 *	\param[out] destination 
 *  \return -1 if double is out of __fixed range, 0 else
 *
 *  \note
 *  
 *  This method is just without data loss for 
 *  exponent(double) <= 0
 *  if exponent > 0 it returns a failure
 *  if exponent < 0 the matisse is cutted by |exponent| bits
 *  
 */
int __doubleToFixed(__double *d, __fixed *f);
//****************************************************************

